*Title: Solving Memory Problems
*Slug: solving-memory-problems

================================================================

PHP limits the amount of memory given for execution of a script. This is controlled by the <{code}>memory_limit<{/code}> configuration option. By default, this limit is set to 8MB. If the script tries to allocate more memory, PHP will display a fatal error in a similar format to this one:

<{code}>Fatal error: Allowed memory size of N bytes exhausted (tried to allocate M bytes) in FILE on line #.<{/code}>

If you experience such an error in activeCollab, you can resolve it with the PHP memory limit increase. It will make more memory space for executing the application.

Open the <{term}>php.ini<{/term}> file, find the line where <{code}>memory_limit<{/code}> option is defined and change it to a higher value. Although 8MB is enough for most activeCollab requests, activeCollab will need more memory in some cases, especially when working with images. For that reason, **we recommend the memory limit to be set to 64MB**. 

The line where the memory limit is defined will look like this:

<{code}>memory_limit = 64M<{/code}>

When you make the change, save the php.ini file and restart your web server.

<{note title="php.ini Edit on Hosted Server"}>Some hosting providers do not allow you to edit the php.ini file on your own. If that is the case, please contact your system administrator or hosting provider and ask them to make this change for you.<{/note}>

<{sub}>Problems with Memory and Image Thumbnail Creation<{/sub}>

Thumbnail creation for images is enabled by default. It resizes images (JPG, GIF and PNG only) smaller than 1MB, so that users can see a preview without downloading the original file. This has caused problems on some setups where the recommended 64MB memory limit was not high enough for performing resize operation.

To resolve it you can set max size of images that will be resized (default is 500kb) or completely turn off thumbnail creation. You can define two new configuration options in the <{path}>config/config.php<{/path}> of your activeCollab:

- <{code}>CREATE_THUMBNAILS<{/code}> - True or False, enable or disable thumbnail creation. True is set by default.
- <{code}>RESIZE_SMALLER_THAN<{/code}> - If <{code}>CREATE_THUMBNAILS<{/code}> is set to true, this option defines maximal size in bytes of images that can be resized. The default is 524288b (500kb). Larger images will be ignored. 

Here is how it would look like in your <{path}>config/config.php<{/path}> if you wanted to have thumbnails enabled for all images smaller than 1MB:

<{code}>define('CREATE_THUMBNAILS', true);
define('RESIZE_SMALLER_THAN', 1048576);<{/code}>